% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonoStats_class.R, R/utils.R
\docType{class}
\name{clonoStats-class}
\alias{clonoStats-class}
\alias{show,clonoStats-method}
\alias{clonoNames}
\alias{clonoNames,clonoStats-method}
\alias{clonoNames,SingleCellExperiment-method}
\alias{clonoAbundance}
\alias{clonoAbundance,clonoStats-method}
\alias{clonoAbundance,SingleCellExperiment-method}
\alias{clonoFrequency}
\alias{clonoFrequency,clonoStats-method}
\alias{clonoFrequency,SingleCellExperiment-method}
\alias{clonoAssignment}
\alias{clonoAssignment,clonoStats-method}
\alias{clonoAssignment,SingleCellExperiment-method}
\alias{clonoGroup}
\alias{clonoGroup,clonoStats-method}
\alias{clonoGroup,SingleCellExperiment-method}
\title{\code{clonoStats} object class}
\usage{
\S4method{show}{clonoStats}(object)

clonoNames(object)

\S4method{clonoNames}{clonoStats}(object)

\S4method{clonoNames}{SingleCellExperiment}(object)

clonoAbundance(object)

\S4method{clonoAbundance}{clonoStats}(object)

\S4method{clonoAbundance}{SingleCellExperiment}(object)

clonoFrequency(object)

\S4method{clonoFrequency}{clonoStats}(object)

\S4method{clonoFrequency}{SingleCellExperiment}(object)

clonoAssignment(object)

\S4method{clonoAssignment}{clonoStats}(object)

\S4method{clonoAssignment}{SingleCellExperiment}(object)

clonoGroup(object)

\S4method{clonoGroup}{clonoStats}(object)

\S4method{clonoGroup}{SingleCellExperiment}(object)
}
\arguments{
\item{object}{a \code{\link{clonoStats}} object or
\code{SingleCellExperiment} object containing \code{clonoStats} results.}
}
\value{
An object of class \code{clonoStats}.
}
\description{
The \code{clonoStats} class is designed to hold the output of
the \code{\link{clonoStats}} function. This always includes two group-level
summaries: clonotype abundances and clonotype frequencies. "Group" most
often refers to sample of origin, but may alternatively refer to any
partitioning of cells, such as clusters. Clonotype names are stored
efficiently in two factors. Additionally, a large, sparse matrix of each
cell's clonotype assignment may be included.
}
\section{Functions}{
\itemize{
\item \code{show(clonoStats)}: a short summary of a \code{clonoStats}
object.

\item \code{clonoNames()}: Get the full clonotype names

\item \code{clonoAbundance()}: Get the clonotype abundance matrix (clonotype
counts per group).

\item \code{clonoFrequency()}: Get the matrix of clonotype frequencies
(singletons, doubletons, etc. per group).

\item \code{clonoAssignment()}: Get the matrix of cell-level clonotype
assignments (mapping cells to clonotypes).

\item \code{clonoGroup()}: Get the factor variable of group labels

}}
\section{Slots}{

\describe{
\item{\code{abundance}}{Summary table of clonotype abundances within each group
(sample). Provides specific information about how often each clonotype is
observed in each group.}

\item{\code{frequency}}{Summary table of clonotype frequencies within each group
(sample). Provides a summary of clonotype abundances (ie. number of
singletons, doubletons, etc.).}

\item{\code{group}}{Factor variable giving the group of origin for each cell.}

\item{\code{assignment}}{Optional matrix of clonotype assignments in each individual
cell. Rows correspond to cells and row sums are all 0 or 1. When using
\code{clonoStats} with \code{method = "unique"} or \code{method =
  "CellRanger"}, all values will be 0 or 1. With \code{method = "EM"},
fractional values are allowed, representing the assignment confidence.}

\item{\code{names1}}{Factor listing the first component of each clonotype name (alpha
chains, for TCR data).}

\item{\code{names2}}{Factor listing the second component of each clonotype name (beta
chains, for TCR data).}
}}

\examples{
data('contigs')
cs <- clonoStats(contigs)
cs

}
\seealso{
\code{\link{clonoStats}}
}
