% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseAlignment.R
\name{XNAPairwiseAlignment}
\alias{XNAPairwiseAlignment}
\alias{XNAPairwiseAlignment,XNAString,character-method}
\title{Pairwise alignment methods for XNAString object}
\usage{
XNAPairwiseAlignment(pattern, subject, ...)

\S4method{XNAPairwiseAlignment}{XNAString,character}(
  pattern,
  subject,
  type = "global",
  substitutionMatrix = NULL,
  fuzzyMatrix = NULL,
  gapOpening = 10,
  gapExtension = 4,
  scoreOnly = FALSE
)
}
\arguments{
\item{pattern}{XNAString object, pattern taken from target slot.}

\item{subject}{a character vector of length 1, an XString, or an XStringSet
object of length 1.}

\item{...}{optional arguments to generic function to support additional
methods}

\item{type}{type of alignment. One of "global", "local", "overlap",
"global-local", and "local-global" where "global" = align whole strings
with end gap penalties, "local" = align string fragments, "overlap" = align
whole strings without end gap penalties, "global-local" = align whole strings
in pattern with consecutive subsequence of subject, "local-global" = align
consecutive subsequence of pattern with whole strings in subject.}

\item{substitutionMatrix}{substitution matrix representing the fixed
substitution scores for an alignment. It cannot be used in conjunction
with patternQuality and subjectQuality arguments.}

\item{fuzzyMatrix}{fuzzy match matrix for quality-based alignments.
It takes values between 0 and 1; where 0 is an unambiguous mismatch, 1
is an unambiguous match, and values in between represent a fraction of
"matchiness".}

\item{gapOpening}{the cost for opening a gap in the alignment.}

\item{gapExtension}{the incremental cost incurred along the length of the
gap in the alignment.}

\item{scoreOnly}{logical to denote whether or not to return just the scores
of the optimal pairwise alignment.}
}
\value{
an instance of class \code{\link{PairwiseAlignments}}
}
\description{
This function performs pairwise alignment for sequences stored in target slot
of XNAString object with subject
}
\examples{
mat <-
 pwalign::nucleotideSubstitutionMatrix(
   match = 1,
   mismatch = -3,
   baseOnly = TRUE
)
s1 <-
  XNAString::XNAString(
    base = "GCGGAGAGAGCACAGATACA",
    sugar = "FODDDDDDDDDDDDDDDDDD",
    target = Biostrings::DNAStringSet("GGCGGAGAGAGCACAGATACA")
  )
  
  XNAString::XNAPairwiseAlignment(s1,
                                  "ACCCACACACACACACACACAC",
                                  "global",
                                  substitutionMatrix = mat
  )
}
