% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XNAStringFromHelm.R
\name{XNAStringFromHelm}
\alias{XNAStringFromHelm}
\title{Create XNAString object from HELM - user interface}
\usage{
XNAStringFromHelm(
  helm,
  name = NA_character_,
  dictionary = xna_dictionary,
  compl_dictionary = complementary_bases,
  remove_linker = TRUE
)
}
\arguments{
\item{helm}{string (or strings vector) with HELM sequence, which contains
one RNA polymer and optionally CHEM element}

\item{name}{character (or character vector)}

\item{dictionary}{data.table with following columns:
"HELM", "type", "symbol".
By default internal XNAString dictionary is used.}

\item{compl_dictionary}{data.table with following columns:
"base", "target". By default internal XNAString dictionary is used}

\item{remove_linker}{logical defines if linker should be clipped from RNA}
}
\value{
XNAString object if single helm, XNAStringSet object otherwise
}
\description{
Create XNAString object from HELM - user interface
}
\examples{
XNAStringFromHelm("RNA1{[dR](A)P.[dR](A)P.[dR](A)}$$$$V2.0")
XNAStringFromHelm("RNA1{[dR](A)P.[dR](A)P.[dR](A)}$$$$V2.0", 'name')
XNAStringFromHelm(c("RNA1{[dR](A)P.[dR](A)P.[dR](A)}$$$$V2.0",
                    "RNA1{[dR](T)P.[dR](T)P.[dR](A)}$$$$V2.0"),
                  c('name1', 'name2'))

}
\author{
Marianna Plucinska
}
