% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphabetFrequency.R
\name{alphabetFrequency}
\alias{alphabetFrequency}
\alias{XNAAlphabetFrequencyFun}
\alias{XNAAlphabetFrequency}
\alias{XNAAlphabetFrequency,XNAString-method}
\alias{XNAAlphabetFrequency,XNAStringSet-method}
\title{XNAAlphabetFrequency returns letters frequency for a given object in base,
sugar or backbone slot}
\usage{
XNAAlphabetFrequencyFun(
  obj,
  slot,
  letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE
)

XNAAlphabetFrequency(
  obj,
  slot,
  letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE,
  ...
)

\S4method{XNAAlphabetFrequency}{XNAString}(
  obj,
  slot,
  letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE
)

\S4method{XNAAlphabetFrequency}{XNAStringSet}(
  obj,
  slot,
  letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE
)
}
\arguments{
\item{obj}{XNAString or XNAStringSet class}

\item{slot}{string (slot name: base, sugar or backbone)}

\item{letters}{character (or character vector)}

\item{matrix_nbr}{numeric (1 or 2, if 1 - first slot's element is use,
if 2 - 2nd element in slot)}

\item{as.prob}{logical - if TRUE frequency returned as probability of
occurence}

\item{base_only}{logical - if TRUE, frequency checked for
'A', 'C', 'G', 'T', other}

\item{...}{optional arguments to generic function to support additional
methods}
}
\value{
matrix (frequency matrix for a given slot)
}
\description{
XNAAlphabetFrequency returns letters frequency for a given object in base,
sugar or backbone slot

XNAAlphabetFrequency method returns alphabet frequency for a given object.
It works for 3 slots: base, sugar and backbone. If matrix_nbr equals 1,
alphabet frequency for the first elements in the slot is returned.
Letters can be given as argument, otherwise unique letters in
object's dictionary are in use.
}
\examples{
xnastring_obj <- XNAString(
  name = "b",
  base = c("AACC", "GGEE"),
  sugar = c("FFOO", "OODD")
)
XNAAlphabetFrequency(obj = xnastring_obj,
                     slot = "base")
XNAAlphabetFrequency(obj = xnastring_obj,
                     slot = "base",
                     as.prob = TRUE)
XNAAlphabetFrequency(obj = xnastring_obj,
                     slot = "base",
                     base_only = TRUE)
XNAAlphabetFrequency(obj = xnastring_obj,
                     slot = "base",
                     letters = c("A", "C"))
XNAAlphabetFrequency(obj = xnastring_obj,
                     slot = "base",
                     matrix_nbr = 2)

xnastring_obj_2 <- XNAString(
  base = c("ATCG"),
  sugar = c("FODD"),
  backbone = c("SBB")
)
XNAStringSet_obj <- XNAStringSet(objects = list(
  xnastring_obj,
  xnastring_obj_2
))
XNAAlphabetFrequency(XNAStringSet_obj, "sugar")
}
