% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setterGetter.R
\name{backbone}
\alias{backbone}
\alias{backbone,XNAString-method}
\alias{backbone,XNAStringSet-method}
\alias{backbone<-}
\alias{backbone<-,XNAString-method}
\alias{backbone<-,XNAStringSet-method}
\title{Backbone setter/getter method}
\usage{
backbone(x, ...)

\S4method{backbone}{XNAString}(x)

\S4method{backbone}{XNAStringSet}(x, i = 1)

backbone(x, ...) <- value

\S4method{backbone}{XNAString}(x) <- value

\S4method{backbone}{XNAStringSet}(x, i = 1) <- value
}
\arguments{
\item{x}{XNAString/XNAStringSet object}

\item{...}{optional arguments to generic function to support
additional methods}

\item{i}{numeric - possibilities: 1 or 2. If 1 - 1st slots elements printed
out, 2nd otherwise. In case the second element is not in the object, empty
char created. This parameter is only available for XNAStringSet objects.}

\item{value}{character vector applied only for setter method}
}
\value{
vector in getter method, XNAStringSet object
(with replaced name slot) in setter method
}
\description{
Getter methods enable extraction of single slots from XNAString
and XNAStringSet objects.
E.g. name method extracts name slot from XNAString/XNAStringSet
object.
}
\details{
Setter methods enable overwriting single slots from XNAString
and XNAStringSet objects.
E.g. name<- method overwrites existing name slot
}
\examples{

my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj <- XNAString(
  name = "b",
  base = "GGE",
  sugar = "FFO",
  dictionary = my_dic
)
backbone(obj)
}
