% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setterGetter.R
\name{compl_dictionary}
\alias{compl_dictionary}
\alias{compl_dictionary,XNAString-method}
\alias{compl_dictionary<-}
\alias{compl_dictionary<-,XNAString-method}
\title{Compl_dictionary setter/getter method}
\usage{
compl_dictionary(x, ...)

\S4method{compl_dictionary}{XNAString}(x)

compl_dictionary(x, ...) <- value

\S4method{compl_dictionary}{XNAString}(x) <- value
}
\arguments{
\item{x}{XNAString/XNAStringSet object}

\item{...}{optional arguments to generic function to support
additional methods}

\item{value}{character vector applied only for setter method}
}
\value{
vector in getter method, XNAStringSet object
(with replaced name slot) in setter method
}
\description{
Getter methods enable extraction of single slots from XNAString
and XNAStringSet objects.
E.g. name method extracts name slot from XNAString/XNAStringSet
object.
}
\details{
Setter methods enable overwriting single slots from XNAString
and XNAStringSet objects.
E.g. name<- method overwrites existing name slot
}
\examples{

my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj <- XNAString(
  name = "b",
  base = "GGE",
  sugar = "FFO",
  dictionary = my_dic
)
compl_dictionary(obj)
}
