% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{concatDict}
\alias{concatDict}
\title{Concatenate HELM-symbol custom dictionary with built-in HELM-symbol
dictionary (xna_dictionary)}
\usage{
concatDict(
  custom_dict,
  default_dict = xna_dictionary,
  helm_colname = "HELM",
  type_colname = "type",
  symbol_colname = "symbol"
)
}
\arguments{
\item{custom_dict}{custom HELM-symbol dictionary}

\item{default_dict}{built-in HELM-symbol dictionary (xna_dictionary)}

\item{helm_colname}{helm column name in custom dictionary}

\item{type_colname}{type column name in custom dictionary}

\item{symbol_colname}{symbol column name in custom dictionary}
}
\value{
data.table
}
\description{
Concatenate HELM-symbol custom dictionary with built-in HELM-symbol
dictionary (xna_dictionary)
}
\examples{
my_dict <- data.table::data.table(
  HELM = c("[[B]]"),
  type = c("base"),
  symbol = c("B")
)
concatDict(my_dict)
}
