% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setterGetter.R
\name{default_backbone}
\alias{default_backbone}
\alias{default_backbone,XNAString-method}
\alias{default_backbone,XNAStringSet-method}
\alias{default_backbone<-}
\alias{default_backbone<-,XNAString-method}
\title{Default_backbone setter/getter method}
\usage{
default_backbone(x, ...)

\S4method{default_backbone}{XNAString}(x)

\S4method{default_backbone}{XNAStringSet}(x)

default_backbone(x, ...) <- value

\S4method{default_backbone}{XNAString}(x) <- value
}
\arguments{
\item{x}{XNAString/XNAStringSet object}

\item{...}{optional arguments to generic function to support
additional methods}

\item{value}{character vector applied only for setter method}
}
\value{
vector in getter method, XNAStringSet object
(with replaced name slot) in setter method
}
\description{
Getter methods enable extraction of single slots from XNAString
and XNAStringSet objects.
E.g. name method extracts name slot from XNAString/XNAStringSet
object.
}
\details{
Setter methods enable overwriting single slots from XNAString
and XNAStringSet objects.
E.g. name<- method overwrites existing name slot
}
\examples{

my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj <- XNAString(
  name = "b",
  base = "GGE",
  default_sugar = 'F',
  default_backbone = 'X',
  dictionary = my_dic
)
default_backbone(obj)
}
