% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dinucleotideFrequency.R
\name{dinucleotideFrequency}
\alias{dinucleotideFrequency}
\alias{XNADinucleotideFrequencyFun}
\alias{XNADinucleotideFrequency}
\alias{XNADinucleotideFrequency,XNAString-method}
\alias{XNADinucleotideFrequency,XNAStringSet-method}
\title{XNADinucleotideFrequencyFun returns double letters frequency for a given
object in base, sugar or backbone slot}
\usage{
XNADinucleotideFrequencyFun(
  obj,
  slot,
  double_letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE
)

XNADinucleotideFrequency(
  obj,
  slot,
  double_letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE,
  ...
)

\S4method{XNADinucleotideFrequency}{XNAString}(
  obj,
  slot,
  double_letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE
)

\S4method{XNADinucleotideFrequency}{XNAStringSet}(
  obj,
  slot,
  double_letters = NA,
  matrix_nbr = 1,
  as.prob = FALSE,
  base_only = FALSE
)
}
\arguments{
\item{obj}{XNAString or XNAStringSet class}

\item{slot}{string (slot name: base, sugar or backbone)}

\item{double_letters}{string (or string vector) - double letters}

\item{matrix_nbr}{numeric (1 or 2, if 1 - first slot's element is use,
if 2 - 2nd element in slot)}

\item{as.prob}{logical - if TRUE frequency returned as probability of
occurence}

\item{base_only}{logical - if TRUE, frequency checked for
'A', 'C', 'G', 'T', other}

\item{...}{optional arguments to generic function to support additional
methods}
}
\value{
matrix (frequency matrix for a given slot)
}
\description{
XNADinucleotideFrequencyFun returns double letters frequency for a given
object in base, sugar or backbone slot

XNADinucleotideFrequency method returns dinucleotide frequency for a given
object.
It works for 3 slots: base, sugar and backbone. If matrix_nbr equals 1,
dinucleotide frequency for the first elements in the slot is returned.
Double letters can be given as argument, otherwise unique double letters in
object's dictionary are in use.
}
\examples{
  my_dic <-
data.table::data.table(
 type = c(rep("base", 3), rep("sugar", 2), rep("backbone", 3)),
 symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
xnastring_obj <- XNAString(
 name = "b",
 base = c("GGEG"),
 sugar = c("FFOO"),
 dictionary = my_dic
)
XNAString::XNADinucleotideFrequency(
 obj = xnastring_obj,
 slot = "base",
 matrix_nbr = 1
)
}
