% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnaStringSetClass.R
\name{dt2Set}
\alias{dt2Set}
\title{Function which creates XNAstringSet object from table with
base, sugar and backbone columns.}
\usage{
dt2Set(
  table,
  col.base = "base",
  col.sugar = "sugar",
  col.backbone = "backbone",
  col.target = "target",
  default_sugar = NA,
  default_backbone = NA,
  compl_dict = complementary_bases
)
}
\arguments{
\item{table}{data.table or data.frame (must incluse
base, sugar and backbone columns)}

\item{col.base}{character (name of base column)}

\item{col.sugar}{character (name of sugar column)}

\item{col.backbone}{character (name of backbone column)}

\item{col.target}{character (name of target column)}

\item{default_sugar}{character - only one letter. Will be replicated
nchar(base) times}

\item{default_backbone}{character - only one letter. Will be replicated
nchar(base)-1 times}

\item{compl_dict}{data.table with following columns:
"base", "target". By default internal XNAString dictionary is used}
}
\value{
XNAStringSet object
}
\description{
Function which creates XNAstringSet object from table with
base, sugar and backbone columns.
}
\examples{
dt <- data.table::data.table(
  base = c("TT", "GG"),
  sugar = c("FF", "FO"),
  backbone = c("S", "S")
)
dt2Set(dt)
}
