% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helm2String.R
\name{helm2String}
\alias{helm2String}
\title{Translate RNA from HELM notation to multi-string notation}
\usage{
helm2String(helm, dictionary = xna_dictionary, remove_linker = TRUE)
}
\arguments{
\item{helm}{string with HELM sequence, which contains one RNA polymer and
optionally CHEM element}

\item{dictionary}{data.table with following columns:
"HELM", "type", "symbol".
By default internal XNAString dictionary is used.}

\item{remove_linker}{logical defines if linker should be clipped from RNA}
}
\value{
named list of strings with following elements: base, sugar, backbone,
conjugate5, conjugate3
}
\description{
This function translates RNA molecules encoded in HELM notation
into multi-string notation. It uses dictionary which links HELM
code for base, sugar and backbone elements with
symbols used in multi-string notation.
}
\examples{
helm2String("RNA1{[dR](A)P.[dR](A)P.[dR](A)}$$$$V2.0")
}
\author{
Marianna Plucinska
}
