% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictFromMimir.R
\name{mimir2XnaDict}
\alias{mimir2XnaDict}
\title{Reformat mimir table to XNA dictionary standards}
\usage{
mimir2XnaDict(table, base.col, sugar.col, backbone.col)
}
\arguments{
\item{table}{data.table or data.frame (must incluse "HELM", "TS_BASE_SEQ",
"TS_SUGAR_SEQ" and "TS_BACKBONE_SEQ" columns)}

\item{base.col}{character (base column name)}

\item{sugar.col}{character (sugar column name)}

\item{backbone.col}{character (backbone column name)}
}
\value{
data.table (written in the xna_dictionary format)
}
\description{
Reformat mimir table to XNA dictionary standards
}
\examples{
dt <- data.table::data.table(HELM = c("([PPG])", "[fR]", "[srP]"),
                 TS_BASE_SEQ = c("F", NA, NA),
                 TS_SUGAR_SEQ = c(NA, NA, 'F'),
                 TS_BACKBONE_SEQ = c(NA, 'S', NA))
mimir2XnaDict(dt, 'TS_BASE_SEQ', 'TS_SUGAR_SEQ', 'TS_BACKBONE_SEQ')

}
