% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setterGetter.R
\name{objects}
\alias{objects}
\alias{objects,XNAStringSet-method}
\title{Objects getter method for XNAStringSet class}
\usage{
objects(x, ...)

\S4method{objects}{XNAStringSet}(x)
}
\arguments{
\item{x}{XNAStringSet object}

\item{...}{optional arguments to generic function to support
additional methods}
}
\value{
list of XNAString objects
}
\description{
Getter methods enable extraction of single slots from
XNAStringSet objects.
E.g. objects method extracts objects slot from XNAStringSet object. It is
a list of XNAString objects.
}
\examples{
my_dic <- data.table::data.table(type = c(rep('base',3),
                                          rep('sugar',2),
                                          rep('backbone',3)),
                                symbol = c('G', 'E', 'A', 'F', 
                                           'O', 'S', 'B', 'X'))
obj2 <- XNAString(name = 'b',
                  base = 'GGE',
                  sugar = 'FFO',
                  dictionary = my_dic)
obj3 <- XNAString(name = 'b',
                  base = c('GGE','EEE'),
                  sugar = c('FFO', 'OOO'),
                  dictionary = my_dic)
XNAStringSetObj <- XNAStringSet(objects=list(obj2, obj3))
objects(XNAStringSetObj)

}
