% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverseComplement.R
\name{XNAReverseComplement}
\alias{XNAReverseComplement}
\alias{XNAReverseComplement,XNAString-method}
\title{Reverse complement sequence based on dictionary}
\usage{
XNAReverseComplement(obj, ...)

\S4method{XNAReverseComplement}{XNAString}(obj)
}
\arguments{
\item{obj}{XNAString object}

\item{...}{optional arguments to generic function to support
additional methods}
}
\value{
string with reverse complement sequence
}
\description{
Reverse complement sequence based on dictionary
}
\examples{
my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj <- XNAString(
  name = "b",
  base = "GGE",
  sugar = "FFO",
  dictionary = my_dic
)
XNAReverseComplement(obj)
}
