% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setterGetter.R
\name{secondary_structure}
\alias{secondary_structure}
\alias{secondary_structure,XNAString-method}
\alias{secondary_structure,XNAStringSet-method}
\alias{secondary_structure<-}
\alias{secondary_structure<-,XNAString-method}
\title{Secondary_structure setter/getter method}
\usage{
secondary_structure(x, ...)

\S4method{secondary_structure}{XNAString}(x)

\S4method{secondary_structure}{XNAStringSet}(x)

secondary_structure(x, ...) <- value

\S4method{secondary_structure}{XNAString}(x) <- value
}
\arguments{
\item{x}{XNAString/XNAStringSet object}

\item{...}{optional arguments to generic function to support
additional methods}

\item{value}{character vector applied only for setter method}
}
\value{
vector in getter method, XNAStringSet object
(with replaced name slot) in setter method
}
\description{
Getter methods enable extraction of single slots from XNAString
and XNAStringSet objects.
E.g. name method extracts name slot from XNAString/XNAStringSet
object.
}
\details{
Setter methods enable overwriting single slots from XNAString
and XNAStringSet objects.
E.g. name<- method overwrites existing name slot
}
\examples{

my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj <- XNAString(
  name = "b",
  base = "GGE",
  sugar = "FFO",
  dictionary = my_dic
)
secondary_structure(obj)
}
