% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dinucleotideFrequency.R
\name{seqDinucleotideFrequency}
\alias{seqDinucleotideFrequency}
\title{Create set of functions and methods to calculate dinucleotide frequency in
base, sugar and backbone slots}
\usage{
seqDinucleotideFrequency(unique_sets, seq, as.prob)
}
\arguments{
\item{unique_sets}{string vector of double letters -these letters pose
column names}

\item{seq}{string (or character) - frequency is calculated for
this string}

\item{as.prob}{logical - if TRUE frequency returned as probability of
occurrence}
}
\value{
numeric - named numeric vector
}
\description{
Create set of functions and methods to calculate dinucleotide frequency in
base, sugar and backbone slots
}
\examples{
seqDinucleotideFrequency(c("AB", "BA", "CD"),
                                   "ABABAB",
                                    as.prob = FALSE)
seqDinucleotideFrequency(c("GC", "CG", "CC"),
                         "GCCG",
                         as.prob = FALSE)
}
