% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnaStringSetClass.R
\name{set2Dt}
\alias{set2Dt}
\title{set2Dt function - changes XNAStringSet object to data.table}
\usage{
set2Dt(obj, slots)
}
\arguments{
\item{obj}{XNAStringSet object}

\item{slots}{slots that are saved as column names (possibilities: "name",
"base", "sugar", "backbone", "target", "conjugate5",
"conjugate3" and  "dictionary" )}
}
\value{
data.table
}
\description{
set2Dt function - changes XNAStringSet object to data.table
}
\examples{
my_dic <- data.table::data.table(type = c(rep('base',3),
                                          rep('sugar',2),
                                          rep('backbone',3)),
                                 symbol = c('G', 'E', 'A', 'F',
                                            'O', 'S', 'B', 'X'))
obj2 <- XNAString(name = 'b',
                  base = 'GGE',
                  sugar = 'FFO',
                  dictionary = my_dic)
obj3 <- XNAString(name = 'b',
                  base = c('GGE','EEE'),
                  sugar = c('FFO', 'OOO'),
                  dictionary = my_dic)
XNAStringSetObj <- XNAStringSet(objects=list(obj2, obj3))
set2Dt(XNAStringSetObj, c('base', 'sugar'))

my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj2 <- XNAString(
  name = "b",
  base = "GGE",
  sugar = "FFO",
  dictionary = my_dic
)
obj3 <- XNAString(
  name = "b",
  base = c("GGE", "EEE"),
  sugar = c("FFO", "OOO"),
  dictionary = my_dic
)
XNAStringSetObj <- XNAStringSet(objects = list(obj2, obj3))
set2Dt(XNAStringSetObj, c("base", "sugar"))
}
