% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{typedListCheck}
\alias{typedListCheck}
\title{Check if all objects are of XNAString class and dictionaries are the same}
\usage{
typedListCheck(object)
}
\arguments{
\item{object}{an object of any class. An object must contain
'objects' (list type) slot}
}
\value{
logical information. Checks the whole list of objects,
TRUE if class of all objects equals 'XNAString' and their dictionaries
are the same.
}
\description{
Check if all objects are of XNAString class and dictionaries are the same
}
\examples{
my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj2 <- XNAString(
  name = "b",
  base = "GGE",
  sugar = "FFO",
  dictionary = my_dic
)
obj3 <- XNAString(
  name = "b",
  base = c("GGE", "EEE"),
  sugar = c("FFO", "OOO"),
  dictionary = my_dic
)
XNAStringSetObj <- XNAStringSet(objects = list(obj2, obj3))
typedListCheck(XNAStringSetObj)
}
