% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnaStringClass.R
\docType{methods}
\name{XNAString-class}
\alias{XNAString-class}
\alias{XNAStringMethod}
\alias{XNAString}
\alias{show,XNAString-method}
\alias{xnastringClass}
\alias{showMethod}
\alias{initialize,XNAString-method}
\alias{initialize}
\alias{seqtype}
\alias{seqtype,XNAString-method}
\title{Development of XNAString class aims at enabling efficient manipulation of
modified oligonucleotide sequences. The class consists of the following
slots: name, base, sugar, backbone, target, conjugate5, conjugate3,
secondary_structure, duplex_structure, dictionary (HELM-string dictionary),
compl_dictionary.}
\usage{
XNAString(
  name,
  base,
  sugar,
  backbone,
  target,
  conjugate5,
  conjugate3,
  secondary_structure,
  duplex_structure,
  dictionary,
  compl_dictionary,
  default_sugar,
  default_backbone
)

\S4method{show}{XNAString}(object)

\S4method{initialize}{XNAString}(
  .Object,
  name,
  base,
  sugar,
  backbone,
  target,
  conjugate5,
  conjugate3,
  secondary_structure,
  duplex_structure,
  dictionary,
  compl_dictionary,
  default_sugar,
  default_backbone
)

seqtype(x)

\S4method{seqtype}{XNAString}(x)
}
\arguments{
\item{name}{string (or character)}

\item{base}{string (or character), RNAString, RNAStringSet, DNAString or
DNAStringSet}

\item{sugar}{string (or character)}

\item{backbone}{string (or character)}

\item{target}{DNAStringSet, DNAString or character}

\item{conjugate5}{string (or character)}

\item{conjugate3}{string (or character)}

\item{secondary_structure}{list}

\item{duplex_structure}{list}

\item{dictionary}{data.table with following columns:
"HELM", "type", "symbol". By default internal XNAString dictionary is used.}

\item{compl_dictionary}{data.table with following columns:
"base", "target". By default internal XNAString dictionary is used}

\item{default_sugar}{character, a single letter which will be replicated
in sugar slot as default value}

\item{default_backbone}{character, a single letter which will be replicated
in backbone slot as default value}

\item{object}{XNAString object}

\item{.Object}{XNAString object}

\item{x}{A single string specifying the type of sequences}
}
\value{
Object which consists of \code{name}, \code{base}, \code{sugar},
\code{backbone}, \code{target}, \code{conjugate5}, \code{conjugate3},
\code{secondary_structure},  \code{duplex_structure},
\code{dictionary}, \code{compl_dictionary}.
}
\description{
The package inherits some of the functionalities from Biostrings package.
In contrary to Biostrings sequences, XNAString classes allow for description
of base sequence, sugar and backbone in a single object.
XNAString is able to capture single stranded oligonucleotides, siRNAs, PNAs,
shRNAs, gRNAs and synthetic mRNAs, and enable users to apply
sequence-manipulating Bioconductor packages to their analysis.
XNAString can read and write a HELM notation, compute alphabet frequency,
align and match targets.
}
\examples{
obj1 <- XNAString(
  base = "ATCG",
  sugar = "FODD",
  conjugate3 = "TAG"
)
obj2 <- XNAString(
  base = "ATCG",
  sugar = "FODD",
  backbone = "SBB"
)
str(obj2)
name(obj2) <- 'a'
base(obj2) <- 'ATTT'
sugar(obj2) <- 'LMFF'
backbone(obj2) <- 'BAB'
conjugate5(obj2) <- 'TFJSJG'
conjugate3(obj2) <- 'ARTSS'
my_dic <- data.table::data.table(type = c(rep('base',3),
                                          rep('sugar',2),
                                          rep('backbone',3)),
                                symbol = c('G', 'E', 'A', 'F',
                                           'O', 'S', 'B', 'X'))
obj1 <- XNAString(base = 'AAE',
                  sugar = 'FFO',
                  backbone='SB',
                  dictionary = my_dic)
obj2 <- XNAString(base = c('EAA', 'AAAA'),
                  sugar = c('FFO', 'OOOO'),
                  name = c('a'),
                  conjugate5 = c('TTT'),
                  dictionary = my_dic)

my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj1 <- XNAString(
  base = "AAE",
  sugar = "FFO",
  backbone = "SB",
  dictionary = my_dic
)
obj2 <- XNAString(
  base = c("EAA", "AAAA"),
  sugar = c("FFO", "OOOO"),
  name = c("a"),
  conjugate5 = c("TTT"),
  dictionary = my_dic
)
}
\author{
Anna Gorska
}
