% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{xnastringElementsNumber}
\alias{xnastringElementsNumber}
\title{Function which checks if XNAString object satisfies predefined slots length}
\usage{
xnastringElementsNumber(
  xnastring_obj,
  cond_name = "==1",
  cond_base,
  cond_sugar,
  cond_backbone,
  cond_target = ">0",
  cond_conj5 = "==1",
  cond_conj3 = "==1"
)
}
\arguments{
\item{xnastring_obj}{XNAString object}

\item{cond_name}{allowed name elements in object}

\item{cond_base}{allowed base elements in object}

\item{cond_sugar}{allowed sugar elements in object}

\item{cond_backbone}{allowed backbone elements in object}

\item{cond_target}{allowed target elements in object}

\item{cond_conj5}{allowed conj5 elements in object}

\item{cond_conj3}{allowed conj3 elements in object}
}
\value{
logical
}
\description{
Function which checks if XNAString object satisfies predefined slots length
}
\examples{
obj <- XNAString(
  base = c("EAA", "AAA"),
  sugar = c("FFO", "OOO"),
  name = c("a"),
  conjugate5 = c("TTT")
)
xnastringElementsNumber(obj,
  cond_name = "==1",
  cond_base = "\%in\% c(1,2)",
  cond_sugar = "\%in\% c(1,2)",
  cond_backbone = "\%in\% c(1,2)",
  cond_target = ">0",
  cond_conj5 = "==1",
  cond_conj = "==1"
)
}
