% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnaStringSetClass.R
\docType{class}
\name{XNAStringSet-class}
\alias{XNAStringSet-class}
\alias{XNAStringSetMethod}
\alias{XNAStringSet}
\alias{show,XNAStringSet-method}
\alias{[,XNAStringSet,ANY,ANY,ANY-method}
\alias{extractionMethods}
\alias{[[,XNAStringSet,ANY,ANY-method}
\title{Create class which consists of XNAString objects given as a list}
\usage{
XNAStringSet(
  objects = NA,
  base = NA,
  sugar = NA,
  backbone = NA,
  target = NA,
  col.base = "base",
  col.sugar = "sugar",
  col.backbone = "backbone",
  col.target = "target",
  default_sugar = NA,
  default_backbone = NA,
  compl_dict = complementary_bases
)

\S4method{show}{XNAStringSet}(object)

\S4method{[}{XNAStringSet,ANY,ANY,ANY}(x, i)

\S4method{[[}{XNAStringSet,ANY,ANY}(x, i)
}
\arguments{
\item{objects}{list of XNAString objects}

\item{base}{string (or character), RNAString, RNAStringSet, DNAString or
DNAStringSet. In use only when objects argument is empty.}

\item{sugar}{string (or character). In use only when objects argument is
empty.}

\item{backbone}{string (or character). In use only when objects argument
is empty.}

\item{target}{DNAStringSet, DNAString or character. In use only when objects
argument is empty.}

\item{col.base}{character (name of base column). In use only when objects
argument is empty.}

\item{col.sugar}{character (name of sugar column). In use only when objects
argument is empty.}

\item{col.backbone}{character (name of backbone column). In use only when o
bjects argument is empty.}

\item{col.target}{character (name of target column). In use only when objects
argument is empty.}

\item{default_sugar}{character - only one letter. Will be replicated
nchar(base) times. In use only when objects argument is
empty.}

\item{default_backbone}{character - only one letter. Will be replicated
nchar(base)-1 times. In use only when objects
argument is empty.}

\item{compl_dict}{data.table with following columns:
"base", "target". By default internal XNAString dictionary is used. In use
only when objects argument is empty.}

\item{object}{XNAStringSet object}

\item{x}{XNAStringSet object}

\item{i}{numeric, integer, character, logical - filter needed for extraction
method}
}
\value{
XNASTringSet object
}
\description{
Create class which consists of XNAString objects given as a list

Create XNAStringSet object

Define show method

Method to extract a row/rows (either by row index or by 'name' slot)
XNAStringSet object is returned.

Method to extract a single row (either by row index or by 'name' slot)
XNAString object is returned.
}
\examples{
my_dic <- data.table::data.table(
  type = c(
    rep("base", 3),
    rep("sugar", 2),
    rep("backbone", 3)
  ),
  symbol = c("G", "E", "A", "F", "O", "S", "B", "X")
)
obj1 <- XNAString(
  name = "a",
  base = "GGE",
  sugar = "FFO",
  backbone = "SB",
  dictionary = my_dic
)
obj2 <- XNAString(
  name = "b",
  base = "GGE",
  sugar = "FFO",
  dictionary = my_dic
)
obj3 <- XNAString(
  name = "b",
  base = c("GGE", "EEE"),
  sugar = c("FFO", "OOO"),
  dictionary = my_dic
)
XNAStringSetObj <- XNAStringSet(objects = list(obj1, obj2, obj3))
}
\author{
Anna Gorska
}
