% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_plot_volcano.R
\name{add_adjusted_pvalues}
\alias{add_adjusted_pvalues}
\alias{add_adjusted_pvalues.data.table}
\alias{add_adjusted_pvalues.SummarizedExperiment}
\title{Add adjusted pvalues}
\usage{
add_adjusted_pvalues(object, ...)

\method{add_adjusted_pvalues}{data.table}(
  object,
  method = "fdr",
  fit = fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  verbose = TRUE,
  ...
)

\method{add_adjusted_pvalues}{SummarizedExperiment}(
  object,
  method = "fdr",
  fit = fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{SummarizedExperiment or (feature) data.table}

\item{...}{for s3 dispatch}

\item{method}{'fdr', 'bonferroni', ... (see `p.adjust.methods`)}

\item{fit}{'limma', 'lm', 'lme', 'lmer'}

\item{coefs}{coefficient (string)}

\item{verbose}{TRUE or FALSE}
}
\value{
SummarizedExperiment
}
\description{
Add adjusted pvalues
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
fdt(object) \%<>\% extract(, 1:2)
object \%<>\% fit_limma()
object \%<>\% extract(order(fdt(.)$`p~Adult-X30dpt~limma`), )
 fdt(object)
(fdt(object) \%<>\% add_adjusted_pvalues('fdr'))
(fdt(object) \%<>\% add_adjusted_pvalues('fdr'))      # smart enough not to add second column
(fdt(object)  \%>\% add_adjusted_pvalues('bonferroni'))
}
