% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_enrichment.R
\name{altenrich}
\alias{altenrich}
\title{Alternative Enrichment Analysis}
\usage{
altenrich(
  object,
  pathwaydt,
  genevar = "gene",
  genesep = "[ ,;]",
  coef = autonomics::coefs(object)[1],
  fit = fits(object)[1],
  significancevar = "p",
  significance = 0.05,
  effectsize = 0,
  n = 3,
  genes = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{SummarizedExperiment}}

\item{pathwaydt}{\code{data.table}, e.g. \code{\link{read_msigdt}}}

\item{genevar}{\code{gene fvar}}

\item{genesep}{\code{string} or \code{NULL}}

\item{coef}{\code{string} in \code{coefs(object)}}

\item{fit}{\code{'limma'}, \code{'lm'}, \code{'lme'}, \code{'lmer'}, \code{'wilcoxon'}}

\item{significancevar}{'p' or 'fdr'}

\item{significance}{significance cutoff}

\item{effectsize}{effectsize   cutoff}

\item{n}{no of detected genes required (for geneset to be examined)}

\item{genes}{whether to record genes}

\item{verbose}{whether to msg}
}
\description{
Alternative Enrichment Analysis
}
\details{
This is an alternative enrichent analysis implementation.
It is more modular: uses four times \code{.enrichment(VERBOSE)?} as backend.
But also four times slower than \code{enrichment}, so not recommended.
It is retaind for testing purposes.

This alternative enrichment implementation
}
\seealso{
[enrichment()]
}
