% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_assertions.R
\name{assert_is_valid_sumexp}
\alias{assert_is_valid_sumexp}
\title{Assert that x is a valid SummarizedExperiment}
\usage{
assert_is_valid_sumexp(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{SummarizedExperiment}

\item{.xname}{see get_name_in_parent}
}
\value{
TRUE or FALSE
}
\description{
Assert that x is a valid SummarizedExperiment
}
\examples{
# VALID
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    x <- read_metabolon(file)
    assert_is_valid_sumexp(x)
# NOT VALID
    rownames(SummarizedExperiment::colData(x)) <- NULL
    # assert_is_valid_sumexp(x)
}
