% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_plot_volcano.R
\name{bin}
\alias{bin}
\alias{bin.logical}
\alias{bin.character}
\alias{bin.factor}
\alias{bin.numeric}
\alias{bin.SummarizedExperiment}
\title{Bin continuous variable}
\usage{
bin(object, ...)

\method{bin}{logical}(object, ...)

\method{bin}{character}(object, ...)

\method{bin}{factor}(object, ...)

\method{bin}{numeric}(object, probs = c(0, 0.33, 0.66, 1), ...)

\method{bin}{SummarizedExperiment}(object, fvar, probs = c(0, 0.33, 0.66, 1), ...)
}
\arguments{
\item{object}{numeric or SummarizedExperiment}

\item{...}{(S3 dispatch)}

\item{probs}{numeric}

\item{fvar}{string or NULL}
}
\value{
factor vector
}
\description{
Bin continuous variable
}
\examples{
# Numeric vector
    object <- rnorm(10, 5, 1)
    bin(object)
# SummarizedExperiment
    file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
    fdt(object <- read_maxquant_proteingroups(file))
    fdt(bin(object, 'pepcounts'))
}
