% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_pca.R
\name{biplot_corrections}
\alias{biplot_corrections}
\title{Biplot batch corrections}
\usage{
biplot_corrections(
  object,
  method = "pca",
  by = "sample_id",
  color = "subgroup",
  covariates = character(0),
  varcols = ceiling(sqrt(1 + length(covariates))),
  plot = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{method}{'pca', 'pls', 'lda', or 'sma'}

\item{by}{svar}

\item{color}{variable mapped to color (symbol)}

\item{covariates}{covariates to be batch-corrected}

\item{varcols}{number of covariate columns}

\item{plot}{TRUE/FALSE: plot?}
}
\value{
grid object
}
\description{
Biplot batch corrections
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file, pca = TRUE, plot = FALSE)
biplot_corrections(object, color = 'subgroup', covariates = c('Sex', 'Diabetes', 'Subject', 'Time'))
}
\seealso{
biplot_covariates
}
