% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit_lmx.R
\name{block2lme}
\alias{block2lme}
\alias{block2lme.list}
\alias{block2lme.formula}
\alias{block2lme.character}
\alias{formula2lmer}
\alias{formula2lm}
\alias{block_vars}
\title{Put block in lme-compatible format}
\usage{
block2lme(block, ...)

\method{block2lme}{list}(block, verbose = TRUE, ...)

\method{block2lme}{formula}(block, verbose = TRUE, ...)

\method{block2lme}{character}(block, verbose = TRUE, ...)

formula2lmer(formula, block)

formula2lm(formula, block)

block_vars(formula)
}
\arguments{
\item{block}{block: charactervector or formula}

\item{...}{required for s3 dispatch}

\item{verbose}{TRUE or FALSE}

\item{formula}{formula}
}
\description{
Put block in lme-compatible format
}
\examples{
# lme: ensure lme-compatiblae block specification
    block2lme( block = list(subject = ~1, batch = ~1))
    block2lme( block =   ~1|subject)
    block2lme( block =   c('subject',    'batch'))

# lm: integrate block into formula as random effect
    formula2lm(   formula = ~ subgroup,  block = c('subject', 'batch') )

# lmer: integrate block into formula as fixed effect
    formula2lmer( formula = ~ subgroup,  block = c('subject',    'batch') )
    formula2lmer( formula = ~ subgroup         + (1|subject) + (1|batch ) )
}
