% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_transform.R
\name{center}
\alias{center}
\title{Center samples}
\usage{
center(
  object,
  selector = rep(TRUE, nrow(object)) == TRUE,
  fun = "median",
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{selector}{logical vector (length = nrow(object))}

\item{fun}{aggregation function (string)}

\item{verbose}{TRUE/FALSE}
}
\value{
SummarizedExperiment
}
\description{
Center samples
}
\examples{
require(matrixStats)
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
fdt(object)$housekeeping <- FALSE
fdt(object)$housekeeping[order(rowVars(values(object)))[1:5]] <- TRUE
values(object)[, object$subgroup=='Adult'] \%<>\% magrittr::add(5)
plot_sample_densities(object)
plot_sample_densities(center(object))
plot_sample_densities(center(object, housekeeping))
}
