% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit_limma.R
\name{code}
\alias{code}
\alias{code.factor}
\alias{code.data.table}
\alias{contr.treatment.explicit}
\alias{code_control}
\alias{contr.diff}
\alias{code_diff}
\alias{code_diff_forward}
\alias{code_deviation}
\alias{code_deviation_first}
\alias{code_helmert}
\alias{code_helmert_forward}
\title{Contrast Code Factor}
\usage{
code(object, ...)

\method{code}{factor}(object, codingfun, verbose = TRUE, ...)

\method{code}{data.table}(object, codingfun, vars = names(object), verbose = TRUE, ...)

contr.treatment.explicit(n)

code_control(n)

contr.diff(n)

code_diff(n)

code_diff_forward(n)

code_deviation(n)

code_deviation_first(n)

code_helmert(n)

code_helmert_forward(n)
}
\arguments{
\item{object}{factor vector}

\item{...}{used for s3 dispatch}

\item{codingfun}{factor coding function
\itemize{
    \item contr.treatment:          intercept = y0,     coefi = yi - y0
    \item contr.treatment.explicit: intercept = y0,     coefi = yi - y0
    \item code_control:             intercept = ymean,  coefi = yi - y0
    \item contr.diff:               intercept = y0,     coefi = yi - y(i-1)
    \item code_diff:                intercept = ymean,  coefi = yi - y(i-1)
    \item code_diff_forward:        intercept = ymean,  coefi = yi - y(i+)
    \item code_deviation:           intercept = ymean,  coefi = yi - ymean (drop last)
    \item code_deviation_first:     intercept = ymean,  coefi = yi - ymean (drop first)
    \item code_helmert:             intercept = ymean,  coefi = yi - mean(y0:(yi-1))
    \item code_helmert_forward:     intercept = ymean,  coefi = yi - mean(y(i+1):yp)
}}

\item{verbose}{TRUE or FALSE}

\item{vars}{svars}

\item{n}{character vector}
}
\value{
(explicitly coded) factor vector
}
\description{
Contrast Code Factor for General Linear Model
}
\details{
A General Linear Model contains:                                                                   \cr
  * An Intercept Coefficient: expressing some form of sample average                               \cr
  * For each numeric variable: a slope coefficient                                                 \cr
  * For each k-leveled factor: (k-1) Contrast Coefficients.                                        \cr
       The interpretation of (intercept and contrast) coefficients depends on the contrast coding function used.
       Several contrast coding functions are available in 'stats' and 'codingMatrices'
       But their (function and coefficient) namings are a bit confusing and unsystematic.
       Instead, the functions below offer an intuitive interface (to the otherwise powerful stats/codingMatrices packages).
       The names of these functions reflect the contrast coding used (treatment, backward, sum, or helmert contrasts).
       They also reflect the intercept interpretation (either first factor's first level or grand mean).
       They all produce intuitive coefficient names (e.g. 't1-t0' rather than just 't1').
       They all have unit scaling (a coefficient of 1 means a backward of 1).
}
\examples{
# Coding functions
    x <- factor(paste0('t', 0:3))
    xlevels <- levels(x)
    contr.treatment(         xlevels)
    contr.treatment.explicit(xlevels)
    contr.diff(              xlevels)
    code_control(            xlevels)
    code_diff(               xlevels)
    code_diff_forward(       xlevels)
    code_deviation(          xlevels)
    code_deviation_first(    xlevels)
    code_helmert(            xlevels)
    code_helmert_forward(    xlevels)

# Code
    x \%<>\% code(contr.treatment)
    x \%<>\% code(contr.treatment.explicit)
    x \%<>\% code(contr.diff)
    x \%<>\% code(code_control)
    x \%<>\% code(code_diff)
    x \%<>\% code(code_diff_forward)
    x \%<>\% code(code_deviation)
    x \%<>\% code(code_deviation_first)
    x \%<>\% code(code_helmert)
    x \%<>\% code(code_helmert_forward)

# Model
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    object \%<>\% fit_limma(codingfun = contr.treatment) # default
    object \%<>\% fit_limma(codingfun = contr.treatment.explicit)
    object \%<>\% fit_limma(codingfun = contr.diff)
    object \%<>\% fit_limma(codingfun = code_control)
    object \%<>\% fit_limma(codingfun = code_diff)
    object \%<>\% fit_limma(codingfun = code_diff_forward)
    object \%<>\% fit_limma(codingfun = code_deviation)
    object \%<>\% fit_limma(codingfun = code_deviation_first)
    object \%<>\% fit_limma(codingfun = code_helmert)
    object \%<>\% fit_limma(codingfun = code_helmert_forward)
}
