% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit.R
\name{coefs}
\alias{coefs}
\alias{coefs.factor}
\alias{coefs.data.table}
\alias{coefs.SummarizedExperiment}
\title{Get coefs}
\usage{
coefs(object, ...)

\method{coefs}{factor}(object, intercept = FALSE, ...)

\method{coefs}{data.table}(object, fit = fits(object), intercept = FALSE, ...)

\method{coefs}{SummarizedExperiment}(object, fit = fits(object), intercept = FALSE, ...)
}
\arguments{
\item{object}{factor, data.table, SummarizedExperiment}

\item{...}{required for s3 dispatch}

\item{intercept}{TRUE or FALSE : whether to include the intercept}

\item{fit}{'limma', 'lm', 'lme', 'lmer', 'wilcoxon'}
}
\value{
character vector
}
\description{
Get coefs
}
\examples{
# Factor
    x <- factor(c('A', 'B', 'C'))
    coefs(x)
    coefs(code(x, contr.treatment.explicit))
    coefs(code(x, code_control))
    
# SummarizedExperiment
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file, fit = 'limma')
    coefs(object)
    coefs(object, intercept = TRUE)
}
