% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_enrichment.R
\name{count_in}
\alias{count_in}
\alias{count_in.character}
\alias{count_in.factor}
\alias{count_in.list}
\alias{collapse_in}
\alias{collapse_in.character}
\alias{collapse_in.factor}
\alias{collapse_in.list}
\alias{count_out}
\alias{count_out.character}
\alias{count_out.factor}
\alias{count_out.list}
\title{Count/Collapse in/outside intersection}
\usage{
count_in(x, ...)

\method{count_in}{character}(x, y, ...)

\method{count_in}{factor}(x, y, ...)

\method{count_in}{list}(x, y, ...)

collapse_in(x, ...)

\method{collapse_in}{character}(x, y, sep, ...)

\method{collapse_in}{factor}(x, y, sep, ...)

\method{collapse_in}{list}(x, y, sep, ...)

count_out(x, ...)

\method{count_out}{character}(x, y, ...)

\method{count_out}{factor}(x, y, ...)

\method{count_out}{list}(x, y, ...)
}
\arguments{
\item{x}{character OR list}

\item{...}{used for S3 dispatch}

\item{y}{character}

\item{sep}{string}
}
\value{
number OR numeric
}
\description{
Count/Collapse in/outside intersection
}
\examples{
# Sets
   contrast1 <- c('a', 'b', 'c', 'd')
     pathway <- c('c', 'd', 'e', 'f')
   contrast2 <- c('e', 'f', 'g', 'h')

# Count outside
   count_out(contrast1, pathway)
   count_out(list(contrast1 = contrast1, contrast2 = contrast2), pathway)

# Count inside
   count_in(contrast1, pathway)
   count_in(list(contrast1 = contrast1, contrast2 = contrast2), pathway)

# Collapse inside
   collapse_in(contrast1, pathway, sep = ' ')
   collapse_in(list(contrast1 = contrast1, contrast2 = contrast2), pathway, sep = ' ')
}
