% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_read_proteingroups.R
\name{dequantify}
\alias{dequantify}
\title{Dequantify maxquant snames}
\usage{
dequantify(x, quantity = guess_maxquant_quantity(x), verbose = FALSE)
}
\arguments{
\item{x}{\code{character}}

\item{quantity}{\verb{'ratio',              'normalizedratio'},  \cr
\code{'LFQ intensity'}, \cr
\verb{'intensity',          'labeledintensity'}
\verb{'reporterintensity', 'correctedreporterintensity'}}

\item{verbose}{\code{TRUE} or \code{FALSE}}
}
\value{
\code{character}
}
\description{
Drop quantity ('Reporter intensity'). \cr
Encode \code{{channel}} as suffix.
}
\details{
\verb{               Ratio H/L WT(L).KD(H).R1  ->  WT(L).KD(H).R1\{H/L\}}
\verb{                    LFQ intensity WT.R1  ->  WT.R1}
\verb{Reporter intensity 0 WT(126).KD(127).R1  ->  WT(1).KD(2).R1\{1\}}
}
\examples{
dequantify(c('Ratio H/L WT(L).KD(M).OE(H).R1',             # Ratios
             'Ratio M/L WT(L).KD(M).OE(H).R1'))
dequantify(c('Ratio H/L normalized WT(L).KD(M).OE(H).R1',  # Norm. Ratios
             'Ratio M/L normalized WT(L).KD(M).OE(H).R1'))
dequantify(c('LFQ intensity WT.R1',                        # LFQ intensity
             'LFQ intensity KD.R1'))
dequantify(c('Reporter intensity 1 WT(126).KD(127).R1',    # Rep.intensities
             'Reporter intensity 2 WT(126).KD(127).R1'))
}
