% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_survival.R
\name{.coxph}
\alias{.coxph}
\alias{.survdiff}
\alias{.logrank}
\title{Fit onefeature survival}
\usage{
.coxph(timetoevent, event, expr)

.survdiff(timetoevent, event, expr)

.logrank(timetoevent, event, expr)
}
\arguments{
\item{timetoevent}{numeric (time to event)}

\item{event}{numeric (1=event, 0=not)}

\item{expr}{numeric (.coxph) or twolevel-factor (.survdiff, .logrank_test)}
}
\description{
Fit onefeature survival
}
\examples{
# Prepare
         object <- survival_example()
    timetoevent <- object$timetoevent
          event <- object$event
           expr <- values(object)[1,]
       quantile <- factor(dplyr::ntile(expr, 2))
# Survival
       .coxph(timetoevent, event, expr)
    .survdiff(timetoevent, event, quantile)
     .logrank(timetoevent, event, quantile)
# Sumexp
         fit_survival(object)
}
