% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_read_proteingroups.R
\name{.read_maxquant_proteingroups}
\alias{.read_maxquant_proteingroups}
\alias{.read_maxquant_phosphosites}
\title{Read proteingroups/phosphosites as-is}
\usage{
.read_maxquant_proteingroups(
  file,
  quantity = guess_maxquant_quantity(file),
  verbose = TRUE
)

.read_maxquant_phosphosites(
  file,
  profile,
  quantity = guess_maxquant_quantity(file),
  verbose = TRUE
)
}
\arguments{
\item{file}{proteingroups / phosphosites file}

\item{quantity}{string}

\item{verbose}{TRUE / FALSE}

\item{profile}{proteingroups file}
}
\value{
data.table
}
\description{
Read proteingroups/phosphosites as-is
}
\examples{
profile <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
fosfile <- system.file('extdata/billing19.phosphosites.txt',  package = 'autonomics')
prodt <- .read_maxquant_proteingroups(file = profile)
fosdt <- .read_maxquant_phosphosites( file = fosfile, profile = profile)
}
