% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.1_read_rnaseq.R
\name{download_gtf}
\alias{download_gtf}
\title{Download GTF file}
\usage{
download_gtf(
  organism,
  release = 100,
  gtffile = sprintf("\%s/gtf/\%s", R_user_dir("autonomics", "cache"),
    basename(make_gtf_url(organism, release) \%>\% substr(1, nchar(.) - 3)))
)
}
\arguments{
\item{organism}{'Homo sapiens', 'Mus musculus' or 'Rattus norvegicus'}

\item{release}{GTF release (number)}

\item{gtffile}{string: path to local GTF file}
}
\value{
gtffile path
}
\description{
Download GTF file with feature annotations
}
\examples{
organism <- 'Homo sapiens'
# download_gtf(organism)
}
