% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{.extract_p_features}
\alias{.extract_p_features}
\alias{.extract_fdr_features}
\alias{.extract_effectsize_features}
\alias{.extract_sign_features}
\alias{.extract_n_features}
\alias{extract_coef_features}
\title{Extract coefficient features}
\usage{
.extract_p_features(
  object,
  coefs,
  p = 0.05,
  fit = fits(object),
  combiner = "|",
  features = NULL,
  verbose = TRUE
)

.extract_fdr_features(
  object,
  coefs,
  fdr = 0.05,
  fit = fits(object),
  combiner = "|",
  features = NULL,
  verbose = TRUE
)

.extract_effectsize_features(
  object,
  coefs,
  effectsize = 1,
  fit = fits(object),
  combiner = "|",
  features = NULL,
  verbose = TRUE
)

.extract_sign_features(
  object,
  coefs,
  sign,
  fit = fits(object)[1],
  combiner = "|",
  features = NULL,
  verbose = TRUE
)

.extract_n_features(
  object,
  coefs,
  combiner = "|",
  n,
  fit = fits(object)[1],
  features = NULL,
  verbose = TRUE
)

extract_coef_features(
  object,
  fit = fits(object)[1],
  coefs = autonomics::coefs(object, fit = fit),
  combiner = "|",
  decreasing = FALSE,
  p = 1,
  fdr = 1,
  effectsize = 0,
  sign = c(-1, +1),
  n = 4,
  features = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedXExperiment}

\item{coefs}{subset of coefs(object)}

\item{p}{p threshold}

\item{fit}{subset of fits(object)}

\item{combiner}{'|' or '&': how to combine multiple fits/coefs}

\item{features}{features to include no matter what (character vector)}

\item{verbose}{TRUE or FALSE}

\item{fdr}{fdr threshold}

\item{effectsize}{effectsize threshold}

\item{sign}{effect sign}

\item{n}{number of top features (Inf means all)}

\item{decreasing}{TRUE or FALSE}
}
\value{
SummarizedExperiment
}
\description{
Extract coefficient features
}
\examples{
# Read and Fit
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    object \%<>\% fit_limma()
    fdt(object) \%<>\% add_adjusted_pvalues('fdr')
# Single coef
    object0 <- object
    object \%<>\% .extract_p_features(         coefs = 't1-t0', p = 0.05)
    object \%<>\% .extract_fdr_features(       coefs = 't1-t0', fdr = 0.05)
    object \%<>\% .extract_effectsize_features(coefs = 't1-t0', effectsize = 1)
    object \%<>\% .extract_sign_features(      coefs = 't1-t0', sign = -1)
    object \%<>\% .extract_n_features(         coefs = 't1-t0', n = 1)
    object <- object0
    object \%<>\%  extract_coef_features(
                   coefs = 't1-t0', p = 0.05, fdr = 0.05, effectsize = 1, sign = -1, n = 1)
# Multiple coefs
    object <- object0
    object \%<>\% .extract_p_features(         coefs = c('t1-t0', 't2-t0'), p = 0.05)
    object \%<>\% .extract_fdr_features(       coefs = c('t1-t0', 't2-t0'), fdr = 0.01)
    object \%<>\% .extract_effectsize_features(coefs = c('t1-t0', 't2-t0'), effectsize = 1)
    object \%<>\% .extract_sign_features(      coefs = c('t1-t0', 't2-t0'), sign = -1)
    object \%<>\% .extract_n_features(         coefs = c('t1-t0', 't2-t0'), n = 1)
    object <- object0
    object \%<>\%  extract_coef_features(
                   coefs = c('t1-t0', 't2-t0'), p = 0.05, fdr = 0.01, effectsize = 1, sign = -1, n = 1)
}
