% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.0_read_omics.R
\name{extract_rectangle}
\alias{extract_rectangle}
\alias{extract_rectangle.character}
\alias{extract_rectangle.data.table}
\alias{extract_rectangle.matrix}
\title{Extract rectangle from omics file, data.table, or matrix}
\usage{
extract_rectangle(x, ...)

\method{extract_rectangle}{character}(
  x,
  rows = seq_len(nrows(x, sheet = sheet)),
  cols = seq_len(ncols(x, sheet = sheet)),
  verbose = FALSE,
  transpose = FALSE,
  drop = FALSE,
  sheet = 1,
  ...
)

\method{extract_rectangle}{data.table}(
  x,
  rows = seq_len(nrow(x)),
  cols = seq_len(ncol(x)),
  transpose = FALSE,
  drop = FALSE,
  ...
)

\method{extract_rectangle}{matrix}(
  x,
  rows = seq_len(nrow(x)),
  cols = seq_len(ncol(x)),
  transpose = FALSE,
  drop = FALSE,
  ...
)
}
\arguments{
\item{x}{omics datafile or datatable}

\item{...}{allow for S3 method dispatch}

\item{rows}{numeric vector}

\item{cols}{numeric vector}

\item{verbose}{logical}

\item{transpose}{logical}

\item{drop}{logical}

\item{sheet}{numeric or string}
}
\value{
matrix
}
\description{
Extract rectangle from omics file, data.table, or matrix
}
\examples{
# FROM FILE: extract_rectangle.character
#=======================================
   x <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
   extract_rectangle(x, rows = 11:30, cols = 15:81, sheet = 2)[ 1:3, 1:3 ]  # exprs
   extract_rectangle(x, rows = 11:30, cols = 2,     sheet = 2)[ 1:3,     ]  # fids
   extract_rectangle(x, rows = 4,     cols = 15:81, sheet = 2)[    , 1:3 ]  # sids
   extract_rectangle(x, rows = 10:30, cols = 1:14,  sheet = 2)[ 1:3, 1:3 ]  # fdt
   extract_rectangle(x, rows = 1:10,  cols = 14:81, sheet = 2, transpose = TRUE)[1:3, 1:3] # sdt

# FROM MATRIX: extract_rectangle.matrix
#======================================
   x <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
   x \%<>\% extract_rectangle(sheet = 2)
   extract_rectangle(x, rows = 11:30,  cols = 15:81, sheet = 2)[ 1:3, 1:3 ]  # exprs
   extract_rectangle(x, rows = 11:30,  cols = 2,     sheet = 2)[ 1:3,     ]  # fids
   extract_rectangle(x, rows = 4,      cols = 15:81, sheet = 2)[    , 1:3 ]  # sids
   extract_rectangle(x, rows = 10:30,  cols = 1:14,  sheet = 2)[ 1:3, 1:3 ]  # fdt
   extract_rectangle(x, rows = 1:10,   cols = 14:81, sheet = 2, transpose = TRUE)[1:3, 1:3] # sdt
}
