% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{fcluster}
\alias{fcluster}
\title{Cluster features}
\usage{
fcluster(
  object,
  distmat = NULL,
  method = "cmeans",
  k = 2:10,
  verbose = TRUE,
  plot = TRUE,
  label = if ("gene" \%in\% fvars(object)) "gene" else "feature_id",
  alpha = 1,
  nrow = if (length(method) > 1) length(method) else NULL,
  ncol = NULL
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{distmat}{distance matrix}

\item{method}{'cmeans'}

\item{k}{number of clusters}

\item{verbose}{TRUE or FALSE}

\item{plot}{TRUE or FALSE}

\item{label}{fvar}

\item{alpha}{fraction}

\item{nrow}{number}

\item{ncol}{number}
}
\value{
SummarizedExperiment

SummarizedExperiment
}
\description{
Cluster features
}
\examples{
object <- twofactor_sumexp()
distmat <- fdist(object)
fcluster(object)                                                   # membership-based colors
fcluster(object, distmat)                                          # silhouette-based colors
fcluster(object, distmat, method = c('cmeans', 'hclust', 'pamk'))  # more methods
}
