% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_get_set.R
\name{fdata}
\alias{fdata}
\alias{sdata}
\alias{fdt}
\alias{sdt}
\alias{fdata,SummarizedExperiment-method}
\alias{sdata,SummarizedExperiment-method}
\alias{fdt,SummarizedExperiment-method}
\alias{sdt,SummarizedExperiment-method}
\alias{fdata<-}
\alias{sdata<-}
\alias{fdt<-}
\alias{sdt<-}
\alias{fdata<-,SummarizedExperiment,data.frame-method}
\alias{sdata<-,SummarizedExperiment,data.frame-method}
\alias{sdata<-,SummarizedExperiment,DataFrame-method}
\alias{fdt<-,SummarizedExperiment,data.table-method}
\alias{sdt<-,SummarizedExperiment,data.table-method}
\title{Get/Set sample/feature data}
\usage{
fdata(object)

sdata(object)

fdt(object)

sdt(object)

\S4method{fdata}{SummarizedExperiment}(object)

\S4method{sdata}{SummarizedExperiment}(object)

\S4method{fdt}{SummarizedExperiment}(object)

\S4method{sdt}{SummarizedExperiment}(object)

fdata(object) <- value

sdata(object) <- value

fdt(object) <- value

sdt(object) <- value

\S4method{fdata}{SummarizedExperiment,data.frame}(object) <- value

\S4method{sdata}{SummarizedExperiment,data.frame}(object) <- value

\S4method{sdata}{SummarizedExperiment,DataFrame}(object) <- value

\S4method{fdt}{SummarizedExperiment,data.table}(object) <- value

\S4method{sdt}{SummarizedExperiment,data.table}(object) <- value
}
\arguments{
\item{object}{SummarizedExperiment}

\item{value}{data.frame/data.table}
}
\value{
data.frame/data.table (get) or updated object (set)
}
\description{
Get/Set sample/feature data
}
\examples{
# Read data
    file <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
    object <- read_maxquant_proteingroups(file)
# sdt/fdt
    sdt(object)[1:3, ]
    fdt(object)[1:3, ]
    sdt(object) \%<>\% cbind(b=1)
    fdt(object) \%<>\% cbind(b=1)
    sdt(object)
    fdt(object)
# sdata/fdata
    sdata(object)[1:3, ]
    fdata(object)[1:3, ]
    sdata(object) \%<>\% cbind(a=1)
    fdata(object) \%<>\% cbind(a=1)
    sdata(object)[1:3, ]
    fdata(object)[1:3, ]
}
