% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_filter.R
\name{filter_exprs_replicated_in_some_subgroup}
\alias{filter_exprs_replicated_in_some_subgroup}
\title{Filter features with replicated expression in some subgroup}
\usage{
filter_exprs_replicated_in_some_subgroup(
  object,
  subgroupvar = "subgroup",
  assay = assayNames(object)[1],
  comparator = if (contains_ratios(object)) "!=" else ">",
  lod = 0,
  nsample = 2,
  nsubgroup = 1,
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{subgroupvar}{subgroup svar}

\item{assay}{string}

\item{comparator}{'>' or '!='}

\item{lod}{number: limit of detection}

\item{nsample}{number}

\item{nsubgroup}{number}

\item{verbose}{TRUE or FALSE}
}
\value{
Filtered SummarizedExperiment
}
\description{
Filter features with replicated expression in some subgroup
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% filter_exprs_replicated_in_some_subgroup()
filter_exprs_replicated_in_some_subgroup(object, character(0))
filter_exprs_replicated_in_some_subgroup(object, NULL)
}
