% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit_limma.R, R/8_fit_lmx.R,
%   R/8_fit_wilcoxon.R
\name{fit_linmod}
\alias{fit_linmod}
\alias{fit_limma}
\alias{.fit_limma}
\alias{fit_lm}
\alias{fit_lme}
\alias{fit_lmer}
\alias{fit_wilcoxon}
\title{Fit General Linear Model}
\usage{
fit_linmod(
  object,
  formula = as.formula("~ subgroup"),
  engine = "limma",
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = create_design(object, formula = formula, drop = drop, codingfun = codingfun,
    verbose = FALSE),
  contrasts = NULL,
  coefs = if (is.null(contrasts)) model_coefs(design = design) else NULL,
  block = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  sep = FITSEP,
  suffix = paste0(sep, engine),
  verbose = TRUE,
  outdir = NULL,
  writefun = "write_xl",
  volcano = FALSE,
  volcanoargs = list(),
  exprs = FALSE,
  exprargs = list(),
  ...
)

fit_limma(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = create_design(object, formula = formula, drop = drop, codingfun = codingfun),
  contrasts = NULL,
  block = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  sep = FITSEP,
  suffix = paste0(sep, "limma"),
  verbose = TRUE
)

.fit_limma(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = create_design(object, formula = formula, drop = drop, codingfun = codingfun),
  contrasts = NULL,
  block = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  sep = FITSEP,
  suffix = paste0(sep, "limma"),
  verbose = TRUE
)

fit_lm(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = NULL,
  block = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  sep = FITSEP,
  suffix = paste0(sep, "lm"),
  contrasts = NULL,
  verbose = TRUE
)

fit_lme(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = NULL,
  block = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  opt = "optim",
  sep = FITSEP,
  suffix = paste0(sep, "lme"),
  contrasts = NULL,
  verbose = TRUE
)

fit_lmer(
  object,
  formula = as.formula("~ subgroup"),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = NULL,
  block = NULL,
  weightvar = if ("weights" \%in\% assayNames(object)) "weights" else NULL,
  sep = FITSEP,
  suffix = paste0(sep, "lmer"),
  contrasts = NULL,
  verbose = TRUE
)

fit_wilcoxon(
  object,
  formula = as.formula("~ subgroup"),
  drop = NULL,
  codingfun = contr.treatment.explicit,
  design = NULL,
  contrasts = NULL,
  block = NULL,
  weightvar = NULL,
  sep = FITSEP,
  suffix = paste0(sep, "wilcoxon"),
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{formula}{model formula}

\item{engine}{'limma', 'lm', 'lme', 'lmer', or 'wilcoxon'}

\item{drop}{TRUE or FALSE}

\item{codingfun}{factor coding function
\itemize{
    \item contr.treatment:          intercept = y0,     coefi = yi - y0
    \item contr.treatment.explicit: intercept = y0,     coefi = yi - y0
    \item code_control:             intercept = ymean,  coefi = yi - y0
    \item contr.diff:               intercept = y0,     coefi = yi - y(i-1)
    \item code_diff:                intercept = ymean,  coefi = yi - y(i-1)
    \item code_diff_forward:        intercept = ymean,  coefi = yi - y(i+)
    \item code_deviation:           intercept = ymean,  coefi = yi - ymean (drop last)
    \item code_deviation_first:     intercept = ymean,  coefi = yi - ymean (drop first)
    \item code_helmert:             intercept = ymean,  coefi = yi - mean(y0:(yi-1))
    \item code_helmert_forward:     intercept = ymean,  coefi = yi - mean(y(i+1):yp)
}}

\item{design}{design matrix}

\item{contrasts}{NULL or character vector: coefficient contrasts to test}

\item{coefs}{NULL or character vector: model coefs to test}

\item{block}{block svar (or NULL)}

\item{weightvar}{NULL or name of weight matrix in assays(object)}

\item{sep}{string: pvar separator  ("~" in "p~t2~limma")}

\item{suffix}{string: pvar suffix ("limma" in "p~t2~limma")}

\item{verbose}{whether to msg}

\item{outdir}{NULL or dir}

\item{writefun}{'write_xl' or 'write_ods'}

\item{volcano}{TRUE or FALSE}

\item{volcanoargs}{list: volcano args}

\item{exprs}{TRUE or FALSE}

\item{exprargs}{list:  expr   args}

\item{...}{passed to fit_(limma|lm|lme|lmer) functions}

\item{opt}{lme options}
}
\value{
Updated SummarizedExperiment
}
\description{
Fit General Linear Model
}
\examples{
# Standard usage
  file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
  object <- read_metabolon(file)
  object \%<>\% fit_linmod()                                # Default
  object \%<>\% fit_linmod(  ~subgroup )                    # Custom formula
  object \%<>\% fit_linmod(  ~subgroup, block = 'Subject')  # Block effect
  summarize_fit(object)
  
# Alternative engines: argument 'engine' or dedicated function
  fdt(object) \%<>\% extract(, 'feature_id')
  object \%<>\% fit_limma(   ~subgroup, block = 'Subject')  # Default engine
  object \%<>\% fit_lm(      ~subgroup, block = 'Subject')  # Traditional
  object \%<>\% fit_lme(     ~subgroup, block = 'Subject')  # Powerful random effects
  object \%<>\% fit_lmer(    ~subgroup, block = 'Subject')  # Yet more powerful random effects
  object \%<>\% fit_wilcoxon(~subgroup, block = 'Subject')  # Non-parametric
  summarize_fit(object)
    
# Alternative coding: backward diffs instead of baseline
  fdt(object) \%<>\% extract(, 'feature_id')
  object \%<>\% fit_limma(     ~ subgroup, block = 'Subject', codingfun = code_diff)
  object \%<>\% fit_lme(       ~ subgroup, block = 'Subject', codingfun = code_diff)
  object \%<>\% fit_lmer(      ~ subgroup, block = 'Subject', codingfun = code_diff)
  summarize_fit(object)
    
# Posthoc contrasts: limma-only, flexible, but sometimes approximate
  fdt(object) \%<>\% extract(, 'feature_id')
  object \%<>\% fit_limma( ~ subgroup, block = 'Subject', codingfun = code_control)
  object \%<>\% fit_limma( ~ 0 + subgroup, block = 'Subject', contrasts = 't1-t0')
      # flexible, but only approximate
      # stat.ethz.ch/pipermail/bioconductor/2014-February/057682.html
        
# Custom separator
  fdt(object) \%<>\% extract(, 'feature_id')
  fdt( fit_limma(object, sep = '.'))
  fdt( fit_limma(object, block = 'Subject', sep = '.') )

# Top-level function also plots and writes
  fit_linmod(object, block = 'Subject', coefs = 't1-t0')
  fit_linmod(object, block = 'Subject', coefs = 't1-t0', volcano = TRUE)
  fit_linmod(object, block = 'Subject', coefs = 't1-t0',   exprs = TRUE)
  fit_linmod(object, block = 'Subject', coefs = 't1-t0', volcano = TRUE, exprs = TRUE)
  fit_linmod(object, block = 'Subject', coefs = 't1-t0', volcano = TRUE, exprs = TRUE, outdir = tempdir())
  fit_linmod(object, block = 'Subject', coefs = 't1-t0', volcano = TRUE, exprs = TRUE, outdir = tempdir())
}
