% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_survival.R
\name{survival_example}
\alias{survival_example}
\alias{fit_survival}
\title{Fit survival}
\usage{
survival_example()

fit_survival(
  object,
  ntile = 2,
  engine = c("survdiff", "coxph", "logrank")[1:2],
  assay = assayNames(object)[1],
  sep = FITSEP,
  verbose = TRUE,
  outdir = NULL,
  plot = if (is.null(outdir)) FALSE else TRUE,
  width = 7,
  height = 7,
  n = min(nrow(object), 9),
  ncol = 3,
  nrow = 3,
  writefunname = "write_xl"
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{ntile}{number}

\item{engine}{'coxph' (survival), 'survdiff' (survival), 'logrank' (coin)}

\item{assay}{string}

\item{sep}{fvar string separator : e.g. '~' gives p~surv~LR50}

\item{verbose}{TRUE or FALSE}

\item{outdir}{dir}

\item{plot}{TRUE or FALSE}

\item{width}{number}

\item{height}{number}

\item{n}{number of features to plot}

\item{ncol}{number of cols}

\item{nrow}{number of rows}

\item{writefunname}{'write_xl' or 'write_ods'}
}
\value{
SummarizedExperiment
}
\description{
Investigates association between expression and survival
}
\details{
Investigates association between expression and survival.                        \cr
\verb{    } Continuous for \code{coxph}.                                         \cr
\verb{    } Categorical for \code{survdiff} or \code{logrank}                    \cr
\verb{        } Samples are split into \code{ntile} expression groups.           \cr
\verb{        } Survival is compared between highest and lowest expressors.      \cr 

Three statistics recorded per engine                                             \cr
\verb{        } \code{p}                                                         \cr
\verb{   } \code{effect: } coef (\code{coxph})                                   \cr
\verb{           } mean survival difference (\code{survdiff, logrank})           \cr
\verb{        } \code{t: } \eqn{z}  (\code{coxph})                               \cr
\verb{           }         \eqn{ \chi^2} (\code{survdiff}, \code{logrank})       \cr
\verb{                } sign reflects whether expression                         \cr
\verb{                } increases (positive) or decreases (negative) survival
}
\examples{
# Defaults
    object <- survival_example()
    fit_survival(object)
# Engines
    fit_survival(object, engine = c('coxph', 'survdiff'))
    fit_survival(object, engine = c('coxph', 'survdiff', 'logrank'))
# Quantiles
    fit_survival(object, engine = 'logrank')
    fit_survival(object, engine = 'logrank', ntile = 4)
# Plot
    fit_survival(object)
    fit_survival(object, plot = TRUE)
    fit_survival(object, engine = c('coxph', 'survdiff', 'logrank'), plot = TRUE)
}
