% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_ftype.R
\name{ftype}
\alias{ftype}
\title{Feature type}
\usage{
ftype(
  object,
  formula = default_formula(object),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  fit = fits(object)[1],
  codingfun = contr.treatment.explicit
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{formula}{model formula}

\item{drop}{TRUE or FALSE}

\item{fit}{'limma', 'lm', 'lme', 'wilcoxon'}

\item{codingfun}{coding function}
}
\value{
SummarizedExperiment
}
\description{
Feature type
}
\examples{
file <- download_data('atkin.metabolon.xlsx')
object <- read_metabolon(file)
object \%<>\% fit_limma(block = 'Subject') # model_coefs !
object \%<>\% ftype()          # model_coefs not contrast_coefs !
fdt(object)                  # because intercept is required to recreate predictions
}
