% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_read_proteingroups.R
\name{guess_maxquant_quantity}
\alias{guess_maxquant_quantity}
\title{Guess maxquant quantity from snames}
\usage{
guess_maxquant_quantity(x)
}
\arguments{
\item{x}{character vector}
}
\value{
string: value from names(MAXQUANT_PATTERNS)
}
\description{
Guess maxquant quantity from snames
}
\examples{
# file
    file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
    guess_maxquant_quantity(file)

# character vector
    x <- "Ratio M/L normalized STD(L)_E00(M)_E01(H)_R1"
    guess_maxquant_quantity(x)

    x <- "Ratio M/L STD(L)_E00(M)_E01(H)_R1"
    guess_maxquant_quantity(x)

    x <- "LFQ intensity E00.R1"
    guess_maxquant_quantity(x)

    x <- "Reporter intensity corrected 0 STD(0)E00(1)E01(2)_R1"
    guess_maxquant_quantity(x)

    x <- "Reporter intensity 0 STD(0)E00(1)E01(2)_R1"
    guess_maxquant_quantity(x)

    x <- "Intensity H STD(L)_E00(M)_E01(H)_R1"
    guess_maxquant_quantity(x)

}
