% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_read_proteingroups.R
\name{invert_subgroups}
\alias{invert_subgroups}
\title{Invert subgroups}
\usage{
invert_subgroups(
  object,
  subgroups = slevels(object, "subgroup"),
  sep = guess_sep(object, "subgroup")
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{subgroups}{character vector: subgroup levels to be inversed}

\item{sep}{string: collapsed string separator}
}
\value{
character vector or SummarizedExperiment
}
\description{
Invert expressions , subgroups, and sample ids
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
invert_subgroups(object)
}
