% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit.R
\name{is_sig}
\alias{is_sig}
\title{Is significant?}
\usage{
is_sig(
  object,
  fit = fits(object)[1],
  contrast = coefs(object),
  quantity = "fdr"
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{subset of autonomics::TESTS}

\item{contrast}{subset of colnames(metadata(object)[[fit]])}

\item{quantity}{value in dimnames(metadata(object)[[fit]])[3]}
}
\value{
matrix: -1 (downregulated), +1 (upregulatd), 0 (not fdr significant)
}
\description{
Is significant?
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
object \%<>\% fit_lm()
object \%<>\% fit_limma()
issig <- is_sig(object, fit = c('lm','limma'), contrast = 'Adult-X30dpt')
plot_contrast_venn(issig)
}
