% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_assertions.R
\name{is_valid_formula}
\alias{is_valid_formula}
\alias{assert_valid_formula}
\title{Is valid formula}
\usage{
is_valid_formula(
  x,
  y,
  .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y)
)

assert_valid_formula(
  x,
  y,
  .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y)
)
}
\arguments{
\item{x}{formula}

\item{y}{SummarizedExperiment}

\item{.xname}{string}

\item{.yname}{string}
}
\value{
TRUE or false
}
\description{
Is valid formula
}
\examples{
object <- matrix(1:9, nrow = 3)
rownames(object) <- sprintf('f\%d', 1:3)
colnames(object) <- sprintf('s\%d', 1:3)
object <- list(exprs = object)
object \%<>\% SummarizedExperiment::SummarizedExperiment()
object$group    <- 'group0'
object$subgroup <- c('A', 'B', 'C')
svars(object)
    is_valid_formula( 'condition',   object)   # not formula
    is_valid_formula( ~condition,    object)   # not svar
    is_valid_formula( ~group,        object)   # not multilevel
    is_valid_formula( ~subgroup,     object)   # TRUE
    is_valid_formula( ~0+subgroup,   object)   # TRUE
    is_valid_formula( ~1,            object)   # TRUE
assert_valid_formula( ~subgroup,     object)
}
