% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_transform.R
\name{log2transform}
\alias{log2transform}
\alias{exp2}
\alias{zscore}
\alias{sscale}
\alias{fscale}
\alias{quantnorm}
\alias{invnorm}
\alias{vsn}
\title{Transform values}
\usage{
log2transform(
  object,
  assay = assayNames(object)[1],
  pseudo = 0,
  verbose = FALSE
)

exp2(object, verbose = FALSE)

zscore(object, verbose = FALSE)

sscale(mat, verbose = FALSE)

fscale(mat, verbose = FALSE)

quantnorm(object, verbose = FALSE)

invnorm(object, verbose = FALSE)

vsn(object, verbose = FALSE, delog = TRUE)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{assay}{character vector : assays for which to perform transformation}

\item{pseudo}{number           : pseudo value to be added prior to transformation}

\item{verbose}{TRUE or FALSE    : whether to msg}

\item{mat}{matrix}

\item{delog}{TRUE or FALSE (vsn)}
}
\value{
Transformed sumexp
}
\description{
Transform values
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)

object                       \%>\% plot_sample_densities()
invnorm(object)              \%>\% plot_sample_densities()

object                       \%>\% plot_sample_densities()
quantnorm(object)            \%>\% plot_sample_densities()

object                       \%>\% plot_sample_densities()
#vsn(object)                  \%>\% plot_sample_densities()  # dataset too small

object                       \%>\% plot_sample_densities()
zscore(object)               \%>\% plot_sample_densities()

object                       \%>\% plot_sample_densities()
exp2(object)                 \%>\% plot_sample_densities()
log2transform(exp2(object))  \%>\% plot_sample_densities()
}
