% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit_limma.R
\name{contrast_coefs}
\alias{contrast_coefs}
\alias{model_coefs}
\title{Get model coefs}
\usage{
contrast_coefs(
  object,
  formula = default_formula(object),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = create_design(object, formula = formula, drop = drop, codingfun = codingfun,
    verbose = FALSE)
)

model_coefs(
  object,
  formula = default_formula(object),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  codingfun = contr.treatment.explicit,
  design = create_design(object, formula = formula, drop = drop, codingfun = codingfun,
    verbose = FALSE)
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{formula}{formula}

\item{drop}{TRUE or FALSE}

\item{codingfun}{coding function (e.g. contr.treatment)}

\item{design}{design matrix}
}
\value{
SummarizedExperiment
}
\description{
Get model coefs
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% fit_limma()
model_coefs(object)
contrast_coefs(object)
}
