% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit.R
\name{modelvar}
\alias{modelvar}
\alias{modelvar.data.table}
\alias{modelvar.SummarizedExperiment}
\alias{effectvar}
\alias{tvar}
\alias{pvar}
\alias{fdrvar}
\alias{abstractvar}
\alias{abstractvar.data.table}
\alias{abstractvar.SummarizedExperiment}
\alias{modelvec}
\alias{modelvec.data.table}
\alias{modelvec.SummarizedExperiment}
\alias{effectvec}
\alias{tvec}
\alias{pvec}
\alias{fdrvec}
\alias{abstractvec}
\alias{abstractvec.data.table}
\alias{abstractvec.SummarizedExperiment}
\alias{modeldt}
\alias{modeldt.data.table}
\alias{modeldt.SummarizedExperiment}
\alias{effectdt}
\alias{tdt}
\alias{pdt}
\alias{modelmat}
\alias{effectmat}
\alias{effectsizemat}
\alias{tmat}
\alias{pmat}
\alias{fdrmat}
\alias{modelfeatures}
\alias{modelfeatures.data.table}
\alias{modelfeatures.SummarizedExperiment}
\alias{upfeatures}
\alias{downfeatures}
\title{Get model variable}
\usage{
modelvar(object, ...)

\method{modelvar}{data.table}(
  object,
  quantity,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit),
  ...
)

\method{modelvar}{SummarizedExperiment}(
  object,
  quantity,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit),
  ...
)

effectvar(
  object,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit)
)

tvar(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

pvar(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

fdrvar(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

abstractvar(object, ...)

\method{abstractvar}{data.table}(
  object,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit),
  ...
)

\method{abstractvar}{SummarizedExperiment}(
  object,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit),
  ...
)

modelvec(object, ...)

\method{modelvec}{data.table}(
  object,
  quantity,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id",
  ...
)

\method{modelvec}{SummarizedExperiment}(
  object,
  quantity,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id",
  ...
)

effectvec(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object)[1],
  fvar = "feature_id"
)

tvec(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id"
)

pvec(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id"
)

fdrvec(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id"
)

abstractvec(object, ...)

\method{abstractvec}{data.table}(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id",
  ...
)

\method{abstractvec}{SummarizedExperiment}(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id",
  ...
)

modeldt(object, ...)

\method{modeldt}{data.table}(
  object,
  quantity,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit),
  ...
)

\method{modeldt}{SummarizedExperiment}(
  object,
  quantity,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit),
  ...
)

effectdt(
  object,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit)
)

tdt(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

pdt(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

modelmat(
  object,
  quantity,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit)
)

modelmat(
  object,
  quantity,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit)
)

effectmat(
  object,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit)
)

effectsizemat(
  object,
  fit = fits(object),
  coef = autonomics::coefs(object, fit = fit)
)

tmat(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

pmat(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

fdrmat(object, fit = fits(object), coef = autonomics::coefs(object, fit = fit))

modelfeatures(object, ...)

\method{modelfeatures}{data.table}(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id",
  significancevar = "p",
  significance = 0.05,
  effectdirection = "<>",
  effectsize = 0,
  ...
)

\method{modelfeatures}{SummarizedExperiment}(object, ...)

upfeatures(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id",
  significancevar = "p",
  significance = 0.05,
  effectsize = 0
)

downfeatures(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  fvar = "feature_id",
  significancevar = "p",
  significance = 0.05,
  effectsize = 0
)
}
\arguments{
\item{object}{data.table or SummarizedExperiment}

\item{...}{S3 dispatch}

\item{quantity}{'p', 'effect', 'fdr', 't', or 'se'}

\item{fit}{string (vector)}

\item{coef}{string (vector)}

\item{fvar}{'feature_id' or other fvar for values (pvec) or names (upfeatures)}

\item{significancevar}{'p' or 'fdr'}

\item{significance}{p or fdr cutoff (fractional number)}

\item{effectdirection}{'<>', '<' or '>'}

\item{effectsize}{effectsize cutoff (positive number)}
}
\value{
string (tvar), matrix (tmat), numeric vector (tvec), character vector (tfeatures)
}
\description{
Get model variable
}
\examples{
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    object \%<>\% fit_limma()
    object \%<>\% fit_lm()

    effectvar(object)
    effectvec(object)[1:3]
     effectdt(object)[1:3, ]
    effectmat(object)[1:3, ]

         tvar(object)
         tvec(object)[1:3]
          tdt(object)[1:3, ]
         tmat(object)[1:3, ]

         pvar(object)
         pvec(object)[1:3]
          pdt(object)[1:3, ]
         pmat(object)[1:3, ]

modelfeatures(object)
 downfeatures(object)
   upfeatures(object)
}
